﻿var language;

function DisableApply(flag)
{
	disabledButton(document.getElementById("saveSystem"), flag);
}

function DisableReset(flag)
{
	disabledButton(document.getElementById("resetSystem"), flag);
}

function ValidateSysName(obj)
{
	var device_name = obj.value;	
	if(validateName(device_name, 0, language) == false)
	{
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function displayTime(timeResponse)
{
	var dayTimeArr = timeResponse.split("days");

	if(dayTimeArr.length > 1)
	{
		var days = dayTimeArr[0];
		var time = dayTimeArr[1];
	}
	else
	{
		var days = 0;
		var time = dayTimeArr[0];
	}
	var timeArr = time.split(":");
	if(language == 0)
	{
		document.getElementById("systemUpTime").innerHTML = days + "Days," + timeArr[0] + "Hours," + timeArr[1] + "Minutes";
	}
	else
	{
		document.getElementById("systemUpTime").innerHTML = days + "天，" + timeArr[0] + "小时，" + timeArr[1] + "分钟";
	}
}

function getDeviceInfo()
{
	var xmlhttp = getHTTPObject();
	var Response;
	var getParams = "type=15&cmd=1&getDeviceInfo=1";

	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);

	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			Response = xmlhttp.responseText.slice(7, -8);
			var sysRes = Response.split("&");
			
			if(sysRes[0] == "")
			{
				document.getElementById("systemDescr").innerHTML = "Vector 32 Channel";
			}
			else
			{
				document.getElementById("systemDescr").innerHTML = sysRes[0];
			}

			var timeResponse = sysRes[1];
			displayTime(timeResponse);
			
			document.getElementById("systemName").value = sysRes[2];
			if(parent && (typeof(parent.setSysName) == "function"))
			{
				parent.setSysName(sysRes[2]);
			}
		}
	}
	xmlhttp.send(getParams);
	return true;
}

function getDeviceUpDayAndTime()
{
	var xmlhttp = getHTTPObject();
	var getParams = "type=15&cmd=1&getDeviceRunTime=1&ran=" + Math.random();

	xmlhttp.open("GET", "/goform/formIPQAM?" + getParams, true);
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			var timeResponse = xmlhttp.responseText.slice(7, -8);
			displayTime(timeResponse);
			setTimeout("getDeviceUpDayAndTime()", 10000);
		}
	}
	xmlhttp.send(null);
	return true;
}

function getSysGlobalParameters()
{
	DisableApply(true);
	DisableReset(true);
	document.body.style.cursor = "wait";
	window.status = "Retrieving data, please wait...";

	getDeviceInfo();

	document.body.style.cursor = "auto";
	window.status = "Done";
	DisableReset(false);
	setTimeout("getDeviceUpDayAndTime()", 1000);
}

function setOtherSysGlobalParameters()
{
	var xmlhttp = getHTTPObject();
	var params = "type=15&cmd=2";
	
	params += "&systemName=" + escape(document.getElementById("systemName").value);			
			
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", params.length);

	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if(language == 0)
			{
				alert("System configuration updated successfully.");
			}
			else
			{
				alert("系统参数已设置成功。");
			}
			getSysGlobalParameters();
		}
	}
	xmlhttp.send(params);
	return true;
}

function setSysGlobalParameters()
{
	if(ValidateSysName(document.getElementById("systemName")) == false)
	{
		return false;
	}
	DisableApply(true);
	DisableReset(true);
	setOtherSysGlobalParameters();
}

function restoreSysGlobalParameters()
{
	var apply = document.getElementById("saveSystem");
	applyDispay(parent.group, apply);

	getSysGlobalParameters();
}

window.onload = function()
{
	language = document.getElementById("language").value;
	restoreSysGlobalParameters();
}